<?php
    // Create Custom Messages
    function TS_VCSC_Markers_Post_Messages($messages) {
		global $post, $post_ID;
		$post_type = get_post_type( $post_ID );
		$obj = get_post_type_object($post_type);
		$singular = $obj->labels->singular_name;
		$messages[$post_type] = array(
			0 => '', // Unused. Messages start at index 1.
			1 => sprintf( __($singular.' updated.')),
			2 => __('Custom field updated.'),
			3 => __('Custom field deleted.'),
			4 => __($singular.' updated.'),
			5 => isset($_GET['revision']) ? sprintf( __($singular.' restored to revision from %s'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
			6 => sprintf( __($singular.' published.')),
			7 => __('Page saved.'),
			8 => sprintf( __($singular.' submitted.')),
			9 => sprintf( __($singular.' scheduled for: <strong>%1$s</strong>.'), date_i18n( __('M j, Y @ G:i'), strtotime($post->post_date))),
			10 => sprintf( __($singular.' draft updated.')),
		);
		return $messages;
    }
    
    // Add Content for Contextual Help Section
    function TS_VCSC_Markers_Post_HelpOld($contextual_help, $screen_id, $screen) { 
        if ('edit-ts_layers' == $screen->id) {
            $contextual_help = '<h2>Map Layers</h2>
            <p>Map layers are intended to be used with the "TS Google Maps PLUS" or "TS Google Maps SINGLE" elements.</p> 
            <p>You can view/edit the details of each map layer (marker, overlay or curveline) by clicking on its name, or you can perform bulk actions using the dropdown menu and selecting multiple items.</p>';
        } else if ('ts_layers' == $screen->id) {
            $contextual_help = '<h2>Editing Map Layers</h2>
            <p>This page allows you to view/modify map layer details. Please make sure to fill out the available boxes with the appropriate details; map layer information can only be used with the "Composium - WP Bakery Page Builder Extensions" plugin.</p>';
        }
        return $contextual_help;
    }
	function TS_VCSC_Markers_Post_HelpNew() {
		$screen 				= get_current_screen();
        $screen_ids 			= array('edit-ts_layers', 'ts_layers');
		if (!in_array($screen->id, $screen_ids)) {
			return;
		}
		$screen->add_help_tab(
			array(
				'id'       		=> 'ts_layers_help',
				'title'    		=> 'Map Layers',
				'callback' 		=> function ($screen, $tab) {
					if ('edit-ts_layers' == $screen->id) {
						echo '<p>Map layers are intended to be used with the "TS Google Maps PLUS" or "TS Google Maps SINGLE" elements.</p> 
                        <p>You can view/edit the details of each map layer (marker, overlay or curveline) by clicking on its name, or you can perform bulk actions using the dropdown menu and selecting multiple items.</p>';
					} else if ('ts_layers' == $screen->id) {
						echo '<p>This page allows you to view/modify map layer details. Please make sure to fill out the available boxes with the appropriate details; map layer information can only be used with the "Composium - WP Bakery Page Builder Extensions" plugin.</p>';
					}
				}
			)
		);
	}
	
	// Add Custom Metaboxes to Post Type
    function TS_VCSC_Markers_Codestar() {
        global $VISUAL_COMPOSER_EXTENSIONS;
		global $pagenow;		
		$screen 							    = TS_VCSC_GetCurrentPostType();
        $prefixA 							    = 'general_';
        $prefixB 							    = 'marker_';
        $prefixC 							    = 'overlay_';
        $prefixD 							    = 'curveline_';
		
		// Migration of Old Metadata for Existing Posts
		if (($screen == 'ts_layers') && ($pagenow == 'post.php')) {
            $marker_data 					    = get_post_meta(get_the_ID(), 'ts_vcsc_layer_data', true);
            //var_dump($marker_data);
		}
		
		// Configure Metabox - Layers
		if (($screen == 'ts_layers') && ($pagenow == 'post-new.php' || $pagenow == 'post.php')) {
        
            // Retrieve Google Maps Default Language Strings
            $TS_VCSC_Google_MapPLUS_Language_Defaults = array(
                'ListenersStart'                => 'Start Listeners',
                'ListenersStop'                 => 'Stop Listeners',
                'MobileShow'                    => 'Show Google Map',
                'MobileHide'                    => 'Hide Google Map',
                'StyleDefault'                  => 'Google Standard',
                'StyleLabel'                    => 'Change Map Style',
                'FilterAll'                     => 'All Groups',
                'FilterLabel'                   => 'Filter by Groups',
                'SelectLabel'                   => 'Zoom to Location',
                'ControlsOSM'                   => 'Open Street',
                'ControlsHome'                  => 'Home',
                'ControlsBounds'                => 'Fit All',
                'ControlsBike'                  => 'Bicycle Trails',
                'ControlsTraffic'               => 'Traffic',
                'ControlsTransit'               => 'Transit',
                'TrafficMiles'                  => 'Miles per Hour',
                'TrafficKilometer'              => 'Kilometers per Hour',
                'TrafficNone'                   => 'No Data Available',
                'SearchButton'                  => 'Find New Location',
                'SearchHolder'                  => 'Enter new location to find ...',
                'SearchGoogle'                  => 'View on Google Maps',
                'SearchDirections'              => 'Get Directions',
                'SearchGroup'                   => 'Map Search',
                'OtherLink'                     => 'Learn More!',
                'PlaceholderMarker'             => 'Select Location',
                'ListingsButton'                => 'Search Locations',
                'ListingsSearch'                => 'Enter existing location to search for ...',
                'SumoConfirm'			        => 'Confirm',
                'SumoCancel'			        => 'Cancel',
                'SumoSelected'			        => 'Selected',
                'SumoAllSelected'		        => 'All Selected!',
                'SumoPlaceholder'		        => 'Select Here',
                'SumoSearchLocations'		    => 'Search Locations',
                'SumoSearchGroups'		        => 'Search Groups',
                'SumoSearchStyles'		        => 'Search Styles',
            );
            $TS_VCSC_Google_MapPLUS_Language    = get_option('ts_vcsc_extend_settings_translationsGoogleMapPLUS',	$TS_VCSC_Google_MapPLUS_Language_Defaults);

            if (class_exists('CSF')) {

                $prefix_page_opts               = 'ts_vcsc_layer_data';

                CSF::createMetabox($prefix_page_opts, array(
                    'title'                     => __( "Map Layer Object Information", "ts_visual_composer_extend" ),
                    'post_type'                 => 'ts_layers',
                    'theme'                     => 'dark',
                    'priority'                  => 'high',
                    'context'                   => 'normal',
                    'show_restore'              => false,
                ));
                // General Layer Settings
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "General Settings", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-tools',
                    'fields'                    => array(
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "General Settings", "ts_visual_composer_extend" ),
                        ),
                        array(
                            'type'    		    => 'submessage',
                            'style'   		    => 'info',
                            'content' 		    => __( 'The following settings allow you to define a map layer object - marker, overlay shape or curveline - that can be used with the page builder elements "TS Google Maps PLUS" and "TS Google Maps SINGLE". Based on the type of layer object selected, additional setting options might be provided or others made unavailable.', "ts_visual_composer_extend" ),
                        ),
                        array(
                            'id'      		    => $prefixA . 'layer_type',
                            'type'    		    => 'select',
                            'title'    		    => __( "Layer Type", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select the type of layer you want to add to the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"marker"                => __( "Marker", "ts_visual_composer_extend"),
                                "overlay"               => __( "Overlay", "ts_visual_composer_extend" ),
                                "curveline"             => __( "Curveline", "ts_visual_composer_extend" ),
                            ),
                            'default' 		    => 'marker',
                            'chosen'      	    => true,
                        ),
                        array(
                            'type'    		    => 'subheading',
                            'content' 		    => __( "Optional Settings", "ts_visual_composer_extend" ),
                        ),
                        array(
                            'id'                => $prefixA . 'layer_identifier',
                            'type'              => 'text',
                            'title'             => __( "Layer ID", "ts_visual_composer_extend" ),
                            'help'	            => __( "Please provide an optional and unique ID for this layer, to be used to identify and target the layer for various internal routines; otherwise, a random ID will be assigned.", "ts_visual_composer_extend"),
                        ), 
                        array(
                            'id'                => $prefixA . 'layer_groups',
                            'type'              => 'tageditor',
                            'title'             => __( "Layer Groups", "ts_visual_composer_extend" ),
							"default"           => "",
							"delimiter"         => "|",
                            "lowercase"         => "false",
                            'help'      		=> __( "Optionally, please provide names of groups this layer belongs to; press ENTER after each group name.", "ts_visual_composer_extend" ),
                        ), 
                        array(
                            'id'                => $prefixA . 'layer_tags',
                            'type'              => 'tageditor',
                            'title'             => __( "Layer Tags", "ts_visual_composer_extend" ),
							"default"           => "",
							"delimiter"         => "|",
                            "lowercase"         => "false",
                            'help'      		=> __( "Optionally, please provide searchable tags for the layer; press ENTER after each tag string.", "ts_visual_composer_extend" ),
                        ),
                        array(
                            'id' 			    => $prefixA . 'layer_featured',
                            'type' 			    => 'media',
                            'title' 			=> __( "Layer Featured Image", "ts_visual_composer_extend" ),
                            'button_title'      => __( "Select Image", "ts_visual_composer_extend" ),
                            'remove_title'      => __( "Remove Image", "ts_visual_composer_extend" ),
                            'url'               => false,
                            'preview'           => true,
                            'library'           => 'image',
                            'help'              => __( "Select an optional featured image to be shown alongside this location within the optional location listing that can be shown below the map.", "ts_visual_composer_extend" ),
                        ),
                        // InfoWindow Styling
                        array(
                            'type'    		    => 'subheading',
                            'content' 		    => __( "InfoWindow Styling", "ts_visual_composer_extend" ),
                        ),
                        array(
                            'id'      		    => $prefixA . 'window_type',
                            'type'    		    => 'select',
                            'title'    		    => __("Infowindow Style", "ts_visual_composer_extend"),
                            'help'    		    => __( "Select what style should be used for the marker and/or overlay infowindows.", "ts_visual_composer_extend" ),
                            'options' => array(
                                "global" 				=> __("Global Map Settings", "ts_visual_composer_extend"),
                                "google" 				=> __("Google Default Style", "ts_visual_composer_extend"),
                                "override"				=> __("Composium Custom Style", "ts_visual_composer_extend"),
                            ),
                            'default' 		    => 'global',
                            'chosen'      	    => true,
                        ),
                        array(
                            'id'      			=> $prefixA . 'window_offset',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Infowindow Offset", "ts_visual_composer_extend" ),
                            'default' 			=> '0',						  
                            'help'    			=> __( "Define an optional vertical offset for the infowindow in relation to the marker image.", "ts_visual_composer_extend" ),
                            'min' 				=> '-100',
                            'max'				=> '100',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'window_type', 'any', 'google,override', true),
                        ),
                        array(
                            'id'      		    => $prefixA . 'window_closer',
                            'type'    		    => 'select',
                            'title'    		    => __("Infowindow Closer Position", "ts_visual_composer_extend"),
                            'help'    		    => __( "Select where the close button for the infowindows should be placed.", "ts_visual_composer_extend" ),
                            'options' => array(
								"topright"              => __("Top Right", "ts_visual_composer_extend"),
								"topcenter"             => __("Top Center", "ts_visual_composer_extend"),
								"topleft"               => __("Top Left", "ts_visual_composer_extend"),								
								"bottomright"           => __("Bottom Right", "ts_visual_composer_extend"),
								"bottomcenter"          => __("Bottom Center", "ts_visual_composer_extend"),
								"bottomleft"            => __("Bottom Left", "ts_visual_composer_extend"),
                            ),
                            'default' 		    => 'topright',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'window_type', '==', 'override', true),
                        ),
                        array(
                            'id'      		    => $prefixA . 'window_shadow',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Infowindow Shadow", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to add a shadow effect to the infowindows.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'  	    => array($prefixA . 'window_type', '==', 'override', true),
                        ),
                        array(
                            'id'      			=> $prefixA . 'window_background',
                            'type'    			=> 'color',
                            'title'   			=> __( "Infowindow Background Color", "ts_visual_composer_extend" ),
                            'default' 			=> '#333333',
                            'rgba'    			=> true,
                            'help'				=> __( "Define the global background color for the infowindows.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'window_type', '==', 'override', true),
                        ),
                        array(
                            'id'      			=> $prefixA . 'window_fontcolor',
                            'type'    			=> 'color',
                            'title'   			=> __( "Infowindow Font Color", "ts_visual_composer_extend" ),
                            'default' 			=> '#ffffff',
                            'rgba'    			=> true,
                            'help'				=> __( "Define the global font color for the infowindows.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'window_type', '==', 'override', true),
                        ),
                        array(
                            'id'      		    => $prefixA . 'window_arrowshow',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Infowindow Arrow", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to add a down arrow to the infowindows, pointing towards the marker.", "ts_visual_composer_extend" ),
                            'default' 		    => true,
                            'dependency'  	    => array($prefixA . 'window_type', '==', 'override', true),
                        ),
                        array(
                            'id'      			=> $prefixA . 'window_arrowcolor',
                            'type'    			=> 'color',
                            'title'   			=> __( "Infowindow Arrow Color", "ts_visual_composer_extend" ),
                            'default' 			=> '#333333',
                            'rgba'    			=> true,
                            'help'				=> __( "Define the global background color for the infowindow arrows.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'window_type|' . $prefixA . 'window_arrowshow', '==|==', 'override|true', true),
                        ),
                    )
                ));
                // Single Marker Location
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "Marker Location", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-map-marked-alt',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'marker', true),
                    'fields'                    => array(
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "Marker Location", "ts_visual_composer_extend" ),
                            //'dependency'      => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker_address',
                            'type'              => 'text',
                            'title'             => __( "Marker Address", "ts_visual_composer_extend" ),
                            'placeholder'       => __( "Find marker location by address ...", "ts_visual_composer_extend" ),
                            'help'	            => __( "Please provide the address for the map marker.", "ts_visual_composer_extend"),
                            //'dependency'  	=> array($prefixA . 'layer_type', '==', 'marker', true),
                        ),                          
                        array(
                            'id'                => $prefixB . 'marker_map',
                            'type'              => 'map',
                            'title'             => __( "Marker Location", "ts_visual_composer_extend" ),
                            'address_field'     => $prefixB . 'marker_address',
                            'height'            => '500px',
                            'placeholder'       => __( "Search map ...", "ts_visual_composer_extend" ),
                            'latitude_text'     => __( "Latitude", "ts_visual_composer_extend" ),
                            'longitude_text'    => __( "Longitude", "ts_visual_composer_extend" ),
                            'settings'          => array(
                                'scrollWheelZoom'       => true,
                            ),
                            //'dependency'      => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                    )
                ));
                // Single Marker Information
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "Marker Information", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-map-marker-alt',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'marker', true),
                    'fields'                    => array(
                        // Marker Style Settings
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "Marker Style", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),                        
                        array(
                            'id'      		    => $prefixB . 'marker_style',
                            'type'    		    => 'select',
                            'title'    		    => __( "Marker Style", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select icon or image source that should be used to represent the marker on the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"default"               => __( "Default Marker", "ts_visual_composer_extend"),
								"internal"              => __( "Marker Selection", "ts_visual_composer_extend" ),
								"image"                 => __( "Wordpress Image", "ts_visual_composer_extend" ),
								"external"              => __( "External Image", "ts_visual_composer_extend" ),	
                            ),
                            'default' 		    => 'default',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'				=> $prefixB . 'marker_internal',
                            'type'				=> "iconpicker",
                            'title'      	    => __( 'Marker Icon', 'ts_visual_composer_extend' ),
                            'settings' 			=> array(
								"emptyIcon" 			=> false,
								"emptyIconValue"		=> 'transparent',
								"iconsPerPage"			=> 198,
								"override"				=> true,
								"type" 					=> 'mapmarkers',
                            ),
                            'default'			=> '',
                            'help'				=> __( "Select the marker image you want to use as marker.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_style', '==|==', 'marker|internal', true),
                        ),
                        array(
                            'id' 			    => $prefixB . 'marker_image',
                            'type' 			    => 'media',
                            'title' 			=> __( "Custom Marker Image", "ts_visual_composer_extend" ),
                            'button_title'      => __( "Select Image", "ts_visual_composer_extend" ),
                            'remove_title'      => __( "Remove Image", "ts_visual_composer_extend" ),
                            'url'               => false,
                            'preview'           => true,
                            'library'           => 'image',
                            'help'              => __( "Select the image you want to use as marker; should have a maximum equal dimension of 64x64.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_style', '==|==', 'marker|image', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker_external',
                            'type'              => 'text',
                            'title'             => __( "External Marker Path", "ts_visual_composer_extend" ),
                            'help'	            => __( "Please provide the full external path to the image to be used for the marker; should have a maximum equal dimension of 64x64.", "ts_visual_composer_extend"),
                            'validate'          => 'TS_VCSC_Codestar_Validate_URL',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_style', '==|==', 'marker|external', true),
                        ),
                        array(
                            'id'      			=> $prefixB . 'marker_width',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Marker Width", "ts_visual_composer_extend" ),
                            'default' 			=> '32',						  
                            'help'    			=> __( "Define the width that should be used to display the marker on the map.", "ts_visual_composer_extend" ),
                            'min' 				=> '16',
                            'max'				=> '96',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_style', '==|any', 'marker|image,external', true),
                        ),
                        array(
                            'id'      			=> $prefixB . 'marker_height',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Marker Height", "ts_visual_composer_extend" ),
                            'default' 			=> '32',						  
                            'help'    			=> __( "Define the height that should be used to display the marker on the map.", "ts_visual_composer_extend" ),
                            'min' 				=> '16',
                            'max'				=> '96',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_style', '==|any', 'marker|image,external', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_animation',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Marker Animation", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to animate the marker when it enters the map.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_entry',
                            'type'    		    => 'select',
                            'title'    		    => __( "Marker Entry", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select the type of animation the marker should have when it enters the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"drop"                  => __( "Drop", "ts_visual_composer_extend"),
								"bounce"                => __( "Bounce", "ts_visual_composer_extend" ),
                            ),
                            'default' 		    => 'drop',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_animation', '==|==', 'marker|true', true),
                        ),
                        // InfoWindow Settings
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "Marker InfoWindow", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_popup',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Auto-Show Infowindow", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if the infowindow should be shown automatically after the map has been rendered; will not be applied if marker clustering is enabled and should be limited to one such popup per map.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_include',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Show Title in InfoWindow", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if the marker title should also be shown in the infowindow.", "ts_visual_composer_extend" ),
                            'default' 		    => true,
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id' 			    => $prefixB . 'marker_content',
                            'type' 			    => 'wp_editor',
                            'title' 		    => __( "InfoWindow Content", "ts_visual_composer_extend" ),
                            'help' 			    => __( "Enter the infowindow content but keep its limited size on the map in mind.", "ts_visual_composer_extend" ),
                            'media_buttons' 	=> false,
                            'tinymce' 			=> true,
                            'quicktags' 		=> true, 
                            'settings' 		    => array(
                                'wpautop' 			=> false, 										// use wpautop?
                                'media_buttons' 	=> false, 										// show insert/upload button(s)
                                'textarea_rows' 	=> 16, 											// rows="..."
                                'tabindex' 			=> '',
                                'editor_css' 		=> '', 											// intended for extra styles for both visual and HTML editors buttons, needs to include the `<style>` tags, can use "scoped".
                                'editor_class' 		=> '', 											// add extra class(es) to the editor textarea
                                'teeny' 			=> false, 										// output the minimal editor config used in Press This
                                'dfw' 				=> false, 										// replace the default fullscreen with DFW (needs specific css)
                                'tinymce' 			=> true, 										// load TinyMCE, can be used to pass settings directly to TinyMCE using an array()
                                'quicktags' 		=> true, 										// load Quicktags, can be used to pass settings directly to Quicktags using an array()
                                'sanitize' 			=> false,
                            ),
                            'sanitize' 		    => false,
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        // Button Settings
                        array(
                            'type'    		    => 'subheading',
                            'content' 		    => __( "Additional Buttons", "ts_visual_composer_extend" ),
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_directions',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Show Directions Button", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to show a link to generate directions inside the infowindow.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker_directions_text',
                            'type'              => 'text',
                            'title'             => __( "Button Text", "ts_visual_composer_extend" ),
                            'default'           => (isset($TS_VCSC_Google_MapPLUS_Language['SearchDirections']) ? $TS_VCSC_Google_MapPLUS_Language['SearchDirections'] : $TS_VCSC_Google_MapPLUS_Language_Defaults['SearchDirections']),
                            'help'	            => __( "Please provide the text string for the directions link button inside the infowindow.", "ts_visual_composer_extend"),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_directions', '==|==', 'marker|true', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_viewer',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Show Google Button", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to show a link to view the marker on an official Google map.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker_viewer_text',
                            'type'              => 'text',
                            'title'             => __( "Button Text", "ts_visual_composer_extend" ),
                            'default'           => (isset($TS_VCSC_Google_MapPLUS_Language['SearchGoogle']) ? $TS_VCSC_Google_MapPLUS_Language['SearchGoogle'] : $TS_VCSC_Google_MapPLUS_Language_Defaults['SearchGoogle']),
                            'help'	            => __( "Please provide the text string for the Google link button inside the infowindow.", "ts_visual_composer_extend"),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_viewer', '==|==', 'marker|true', true),
                        ),   
                        array(
                            'id'      		    => $prefixB . 'marker_link',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Show Extra Button", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to provide another custom link button inside the infowindow.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'        => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_url',
                            'type'   		    => 'advancedlinks',
                            'title'    		    => __("Link + Title", "ts_visual_composer_extend"),
                            'help'              => __("Provide an optional link to another site/page, to be used for the extra button inside the infowindow.", "ts_visual_composer_extend"),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_link', '==|==', 'marker|true', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker_button',
                            'type'              => 'text',
                            'title'             => __( "Button Text", "ts_visual_composer_extend" ),
                            'default'           => (isset($TS_VCSC_Google_MapPLUS_Language['OtherLink']) ? $TS_VCSC_Google_MapPLUS_Language['OtherLink'] : $TS_VCSC_Google_MapPLUS_Language_Defaults['OtherLink']),
                            'help'	            => __( "Please provide the text string for the extra link button inside the infowindow.", "ts_visual_composer_extend"),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_link', '==|==', 'marker|true', true),
                        ), 
                        // Streetview Settings
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "Streetview Settings", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_streetview',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Trigger Streetview", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if clicking the marker should also open a streetview, along with the optional infowindow.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'marker', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker_streetadjust',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Streetview: Point-Of-View", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to adjust the point-of-view for the streetview (heading and pitch).", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_streetview', '==|==', 'marker|true', true),
                        ),
                        array(
                            'id'    	        => $prefixB . 'marker_streetheading',
                            'type'  	        => 'slider',
                            'title' 	        => __( "Streetview: Heading", "ts_visual_composer_extend" ),
                            'min'               => 0,
                            'max'               => 360,
                            'step'              => 1,
                            'unit'              => '°',
                            'default'           => 0,
                            'help'              => __( "Define the rotation angle around the camera locus in degrees relative from true north. Headings are measured clockwise (90 degrees is true east).", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_streetview|' . $prefixB . 'marker_streetadjust', '==|==|==', 'marker|true|true', true),
                        ),
                        array(
                            'id'    	        => $prefixB . 'marker_streetpitch',
                            'type'  	        => 'slider',
                            'title' 	        => __( "Streetview: Pitch", "ts_visual_composer_extend" ),
                            'min'               => -90,
                            'max'               => 90,
                            'step'              => 1,
                            'unit'              => '°',
                            'default'           => 0,
                            'help'              => __( "Definee the angle variance 'up' or 'down' from the camera's initial default pitch, which is often (but not always) flat horizontal.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker_streetview|' . $prefixB . 'marker_streetadjust', '==|==|==', 'marker|true|true', true),
                        ),
                    )
                ));
                // Curveline Marker Locations
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "Curveline Locations", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-map-marked-alt',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'curveline', true),
                    'fields'                    => array(

                    )
                ));
                // Curveline Start Marker Information
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "Start Marker Information", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-map-pin',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'curveline', true),
                    'fields'                    => array(
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "Start Marker Style", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'curveline', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker1_style',
                            'type'    		    => 'select',
                            'title'    		    => __( "Marker Style", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select icon or image source that should be used to represent the marker on the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"default"               => __( "Default Marker", "ts_visual_composer_extend"),
								"internal"              => __( "Marker Selection", "ts_visual_composer_extend" ),
								"image"                 => __( "Wordpress Image", "ts_visual_composer_extend" ),
								"external"              => __( "External Image", "ts_visual_composer_extend" ),	
                            ),
                            'default' 		    => 'default',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'curveline', true),
                        ),
                        array(
                            'id'				=> $prefixB . 'marker1_internal',
                            'type'				=> "iconpicker",
                            'title'      	    => __( 'Marker Icon', 'ts_visual_composer_extend' ),
                            'settings' 			=> array(
								"emptyIcon" 			=> false,
								"emptyIconValue"		=> 'transparent',
								"iconsPerPage"			=> 198,
								"override"				=> true,
								"type" 					=> 'mapmarkers',
                            ),
                            'default'			=> '',
                            'help'				=> __( "Select the marker image you want to use as marker.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker1_style', '==|==', 'curveline|internal', true),
                        ),
                        array(
                            'id' 			    => $prefixB . 'marker1_image',
                            'type' 			    => 'media',
                            'title' 			=> __( "Custom Marker Image", "ts_visual_composer_extend" ),
                            'button_title'      => __( "Select Image", "ts_visual_composer_extend" ),
                            'remove_title'      => __( "Remove Image", "ts_visual_composer_extend" ),
                            'url'               => false,
                            'preview'           => true,
                            'library'           => 'image',
                            'help'              => __( "Select the image you want to use as marker; should have a maximum equal dimension of 64x64.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker1_style', '==|==', 'curveline|image', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker1_external',
                            'type'              => 'text',
                            'title'             => __( "External Marker Path", "ts_visual_composer_extend" ),
                            'help'	            => __( "Please provide the full external path to the image to be used for the marker; should have a maximum equal dimension of 64x64.", "ts_visual_composer_extend"),
                            'validate'          => 'TS_VCSC_Codestar_Validate_URL',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker1_style', '==|==', 'curveline|external', true),
                        ),
                        array(
                            'id'      			=> $prefixB . 'marker1_width',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Marker Width", "ts_visual_composer_extend" ),
                            'default' 			=> '32',						  
                            'help'    			=> __( "Define the width that should be used to display the marker on the map.", "ts_visual_composer_extend" ),
                            'min' 				=> '16',
                            'max'				=> '96',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker1_style', '==|any', 'curveline|image,external', true),
                        ),
                        array(
                            'id'      			=> $prefixB . 'marker1_height',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Marker Height", "ts_visual_composer_extend" ),
                            'default' 			=> '32',						  
                            'help'    			=> __( "Define the height that should be used to display the marker on the map.", "ts_visual_composer_extend" ),
                            'min' 				=> '16',
                            'max'				=> '96',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker1_style', '==|any', 'curveline|image,external', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker1_animation',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Marker Animation", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to animate the marker when it enters the map.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'curveline', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker1_entry',
                            'type'    		    => 'select',
                            'title'    		    => __( "Marker Style", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select the type of animation the marker should have when it enters the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"drop"                  => __( "Drop", "ts_visual_composer_extend"),
								"bounce"                => __( "Bounce", "ts_visual_composer_extend" ),
                            ),
                            'default' 		    => 'drop',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker1_animation', '==|==', 'curveline|true', true),
                        ),
                    )
                ));
                // Curveline End Marker Information
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "End Marker Information", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-map-pin',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'curveline', true),
                    'fields'                    => array(
                        array(
                            'type'    		    => 'heading',
                            'content' 		    => __( "Start Marker Style", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'curveline', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker2_style',
                            'type'    		    => 'select',
                            'title'    		    => __( "Marker Style", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select icon or image source that should be used to represent the marker on the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"default"               => __( "Default Marker", "ts_visual_composer_extend"),
								"internal"              => __( "Marker Selection", "ts_visual_composer_extend" ),
								"image"                 => __( "Wordpress Image", "ts_visual_composer_extend" ),
								"external"              => __( "External Image", "ts_visual_composer_extend" ),	
                            ),
                            'default' 		    => 'default',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'curveline', true),
                        ),
                        array(
                            'id'				=> $prefixB . 'marker2_internal',
                            'type'				=> "iconpicker",
                            'title'      	    => __( 'Marker Icon', 'ts_visual_composer_extend' ),
                            'settings' 			=> array(
								"emptyIcon" 			=> false,
								"emptyIconValue"		=> 'transparent',
								"iconsPerPage"			=> 198,
								"override"				=> true,
								"type" 					=> 'mapmarkers',
                            ),
                            'default'			=> '',
                            'help'				=> __( "Select the marker image you want to use as marker.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker2_style', '==|==', 'curveline|internal', true),
                        ),
                        array(
                            'id' 			    => $prefixB . 'marker2_image',
                            'type' 			    => 'media',
                            'title' 			=> __( "Custom Marker Image", "ts_visual_composer_extend" ),
                            'button_title'      => __( "Select Image", "ts_visual_composer_extend" ),
                            'remove_title'      => __( "Remove Image", "ts_visual_composer_extend" ),
                            'url'               => false,
                            'preview'           => true,
                            'library'           => 'image',
                            'help'              => __( "Select the image you want to use as marker; should have a maximum equal dimension of 64x64.", "ts_visual_composer_extend" ),
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker2_style', '==|==', 'curveline|image', true),
                        ),
                        array(
                            'id'                => $prefixB . 'marker2_external',
                            'type'              => 'text',
                            'title'             => __( "External Marker Path", "ts_visual_composer_extend" ),
                            'help'	            => __( "Please provide the full external path to the image to be used for the marker; should have a maximum equal dimension of 64x64.", "ts_visual_composer_extend"),
                            'validate'          => 'TS_VCSC_Codestar_Validate_URL',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker2_style', '==|==', 'curveline|external', true),
                        ),
                        array(
                            'id'      			=> $prefixB . 'marker2_width',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Marker Width", "ts_visual_composer_extend" ),
                            'default' 			=> '32',						  
                            'help'    			=> __( "Define the width that should be used to display the marker on the map.", "ts_visual_composer_extend" ),
                            'min' 				=> '16',
                            'max'				=> '96',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker2_style', '==|any', 'curveline|image,external', true),
                        ),
                        array(
                            'id'      			=> $prefixB . 'marker2_height',
                            'type'    			=> 'slider',
                            'title'   			=> __( "Marker Height", "ts_visual_composer_extend" ),
                            'default' 			=> '32',						  
                            'help'    			=> __( "Define the height that should be used to display the marker on the map.", "ts_visual_composer_extend" ),
                            'min' 				=> '16',
                            'max'				=> '96',
                            'step'				=> '1',
                            'unit'				=> 'px',
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker2_style', '==|any', 'curveline|image,external', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker2_animation',
                            'type'   		    => 'buttonswitch',
                            'title'    		    => __( "Marker Animation", "ts_visual_composer_extend" ),
                            'help'              => __( "Switch the toggle if you want to animate the marker when it enters the map.", "ts_visual_composer_extend" ),
                            'default' 		    => false,
                            'dependency'  	    => array($prefixA . 'layer_type', '==', 'curveline', true),
                        ),
                        array(
                            'id'      		    => $prefixB . 'marker2_entry',
                            'type'    		    => 'select',
                            'title'    		    => __( "Marker Style", "ts_visual_composer_extend" ),
                            'help'    		    => __( "Select the type of animation the marker should have when it enters the map.", "ts_visual_composer_extend" ),
                            'options' => array(
								"drop"                  => __( "Drop", "ts_visual_composer_extend"),
								"bounce"                => __( "Bounce", "ts_visual_composer_extend" ),
                            ),
                            'default' 		    => 'drop',
                            'chosen'      	    => true,
                            'dependency'  	    => array($prefixA . 'layer_type|' . $prefixB . 'marker2_animation', '==|==', 'curveline|true', true),
                        ),
                    )
                ));
                // Overlay Points
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "Overlay Points", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-map-marked-alt',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'overlay', true),
                    'fields'                    => array(

                    )
                ));
                // Overlay Information
                CSF::createSection($prefix_page_opts, array(
                    'title'                     => __( "Overlay Style", "ts_visual_composer_extend" ),
                    'icon'                      => 'fa fa-layer-group',
                    'dependency'  	            => array($prefixA . 'layer_type', '==', 'overlay', true),
                    'fields'                    => array(

                    )
                ));
            }
		}
	}
    
    // Load Required JS+CSS Files
	function TS_VCSC_Markers_Post_Files() {
        global $VISUAL_COMPOSER_EXTENSIONS;
		global $pagenow;
		$screen = TS_VCSC_GetCurrentPostType();
		if ($screen=='ts_layers') {
			if ($pagenow=='post-new.php' || $pagenow=='post.php') {
				if (!wp_script_is('jquery')) {
					wp_enqueue_script('jquery');
				}
				wp_enqueue_style('ts-font-teammates');
				wp_enqueue_style('ts-extend-posttypes');
				wp_enqueue_script('ts-extend-posttypes');
			}
		}
    }
    
	// Remove RevSlider + Essential Grid Metaboxes
	function TS_VCSC_Markers_RemoveExternalMetaboxes() { 
		global $pagenow;
		$screen = TS_VCSC_GetCurrentPostType();
		if ($screen=='ts_layers') {
			if ($pagenow=='post-new.php' || $pagenow=='post.php') {
				remove_meta_box('eg-meta-box', 'ts_layers', 'normal'); 
				remove_meta_box('mymetabox_revslider_0', 'ts_layers', 'normal'); 
			} 
		} 
	}    
		
    // Create Custom Columns
	function TS_VCSC_Markers_Set_CustomColumn_PostType($defaults) {
		$defaults = array_merge(
            $defaults,
            array('layertype'                           => _x('Layer Type', 'ts_visual_composer_extend')),
            array('groups'                              => _x('Groups', 'ts_visual_composer_extend')),
            array('tags'                                => _x('Tags', 'ts_visual_composer_extend')),
            array('ids'                                 => _x('ID', 'ts_visual_composer_extend'))	
		);
		return $defaults;
	}
    
    // Pull Data for Custom Columns
	function TS_VCSC_Markers_Get_CustomColumn_Data($columns, $post_id) {
        $layer_data 				= get_post_meta($post_id, 'ts_vcsc_layer_core', true);
        if ($columns === 'layertype') {
            echo ucfirst(isset($layer_data['layer_type']) ? $layer_data['layer_type'] : __('N/A', 'ts_visual_composer_extend'));
        } else if ($columns === 'groups') {
            echo str_replace('|', ', ', (isset($layer_data['layer_groups']) ? $layer_data['layer_groups'] : __('-', 'ts_visual_composer_extend')));
        } else if ($columns === 'tags') {
            echo str_replace('|', ', ', (isset($layer_data['layer_tags']) ? $layer_data['layer_tags'] : __('-', 'ts_visual_composer_extend')));
		} else if ($columns === 'ids') {
            echo $post_id;
        }
	}
    
    // Create Custom Columns Styling
    function TS_VCSC_Markers_AdjustColumnWidths() {
        echo '<style type="text/css">
            .column-previews {text-align: left; width: 175px !important; overflow: hidden;}
            .column-ids {text-align: left; width: 60px !important; overflow: hidden;}
        </style>';
    }
    
	// Make Customs Columns Sortable		
	function TS_VCSC_Markers_Sort_CustomColumns($columns) {
        $columns['layertype']                           = 'layertype';
        $columns['groups']                              = 'groups';
        $columns['tags']                                = 'tags';
        $columns['ids']                                 = 'ids';
		return $columns;
    }
    
	// Set Layer Core Data When Saving
	function TS_VCSC_Markers_Save_CoreData($post_id, $post, $update) {
		if (isset($_POST['ts_vcsc_layer_data']['general_layer_type'])) {
			$post_core				= array(
                'layer_type'		    => (isset($_POST['ts_vcsc_layer_data']['general_layer_type'])              ? $_POST['ts_vcsc_layer_data']['general_layer_type']               : __('N/A', 'ts_visual_composer_extend')),
                'layer_identifier'		=> (isset($_POST['ts_vcsc_layer_data']['general_layer_identifier'])        ? $_POST['ts_vcsc_layer_data']['general_layer_identifier']         : __('N/A', 'ts_visual_composer_extend')),
                'layer_groups'		    => (isset($_POST['ts_vcsc_layer_data']['general_layer_groups'])            ? $_POST['ts_vcsc_layer_data']['general_layer_groups']             : __('N/A', 'ts_visual_composer_extend')),
                'layer_tags'		    => (isset($_POST['ts_vcsc_layer_data']['general_layer_tags'])              ? $_POST['ts_vcsc_layer_data']['general_layer_tags']               : __('N/A', 'ts_visual_composer_extend')),
			);			
		} else {
			$post_core				= array();
		}
		update_post_meta($post_id, 'ts_vcsc_layer_core', $post_core);
	}
	
	// Call All Routines
	if (is_admin()) {
        //add_action('contextual_help', 							'TS_VCSC_Markers_Post_HelpOld',                 10, 3);
        add_action("load-edit.php", 								'TS_VCSC_Markers_Post_HelpNew');        		
        add_action("load-post.php", 								'TS_VCSC_Markers_Post_HelpNew');
        add_action("load-post-new.php",                             'TS_VCSC_Markers_Post_HelpNew');
        add_action('plugins_loaded',                                'TS_VCSC_Markers_Codestar',                     9999999999);
        add_action('admin_head',                                    'TS_VCSC_Markers_AdjustColumnWidths');
		add_action('admin_enqueue_scripts',							'TS_VCSC_Markers_Post_Files', 				    9999999999);        
		add_action('add_meta_boxes', 								'TS_VCSC_Markers_RemoveExternalMetaboxes', 	    9999999999);		
		add_action('manage_ts_layers_posts_custom_column', 		    'TS_VCSC_Markers_Get_CustomColumn_Data',        10, 2);
        add_filter('post_updated_messages', 						'TS_VCSC_Markers_Post_Messages');
        add_filter('manage_ts_layers_posts_columns', 				'TS_VCSC_Markers_Set_CustomColumn_PostType');
        add_filter('manage_edit-ts_layers_sortable_columns',        'TS_VCSC_Markers_Sort_CustomColumns');
        add_action('save_post_ts_layers',                           'TS_VCSC_Markers_Save_CoreData', 		        10, 3);	
	}
?>